/* Adobe.Wiggler.js */

define(["lib/Zoot"], function (Zoot) {
	"use strict";

return {
		about: "$$$/private/animal/Behavior/Wiggler/About=Wiggler, (c) 2014.",
		description: "$$$/animal/Behavior/Wiggler/Desc=Wiggles vector shapes (AI files that are not set to Render As Image)",
		uiName: "$$$/animal/Behavior/Wiggler/UIName=Wiggler",
		defaultArmedForRecordOn: true,
	
		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{ id: "wiggliness", type: "slider", uiName: "$$$/animal/Behavior/Wiggler/Parameter/wiggliness=Wiggliness", min: 0, max: 500, precision: 2, dephault: 4 }
			];
		},
		
		onCreateBackStageBehavior: function (self) {
		// method on backstage behavior just before it is attached to a puppet; self is the new backstage behavior
		// which will contain these properties: boundPuppet, projectBehavior, getParam(id)/setParam(id, value) [or just allow this.id syntax?], addParam(), removeParam(),  
		// here you might walk the handles of your puppet and bind handle parameters or change defaults accordingly
		// the already-bound other behaviors can be examined, and this function can return a suggested index for its order,
		// and also its priority (i.e. how many simulation time-slices per rendered frame)
			self.impl_ = null;

			return { order: 1.0, importance : 0.0 };
		},
		
		onCreateStageBehavior: function (self, args) {
			self.impl_ = [];

			var container = args.stagePuppet.getDisplayContainer();
			if (container) {
				self.impl_.push(new Zoot.Squiggle(container, 0.1, 6, 1231243124));
			}
		},
		
		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage
			var wig = args.getParam("wiggliness");
			self.impl_.forEach(function (s) {
				s.apply(args.t + args.globalRehearseTime, wig);
			});
		}
		
		}; // end of object being returned
});
